/**
* \file: TouchListener.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <pthread_adit.h>
#include "TouchListener.h"

LOG_IMPORT_CONTEXT(aauto_input)

namespace adit { namespace aauto
{

using namespace std;

struct wl_touch_listener TouchListener::Listener =
{
    TouchListener::handleDown,
    TouchListener::handleUp,
    TouchListener::handleMotion,
    TouchListener::handleFrame,
    TouchListener::handleCancel,
    NULL,
    NULL
};

TouchListener::TouchListener(InputReport& inInputReport, int inWidth, int inHeight,
        bool inVerbose, WaylandDeviceType inDeviceType) : report(inInputReport)
{
    x = 0;
    y = 0;

    width = inWidth;
    height = inHeight;
    verbose = inVerbose;

    wlDeviceType = inDeviceType;
}

TouchListener::~TouchListener()
{
    // do nothing
}

void TouchListener::handleDown(void* inData, struct wl_touch* inTouch, uint32_t inSerial,
        uint32_t inTime, struct wl_surface* inSurface, int32_t inID, wl_fixed_t inX, wl_fixed_t inY)
{
    (void)inTouch;
    (void)inSerial;
    (void)inTime;
    (void)inSurface;

    auto me = static_cast<TouchListener*>(inData);

    me->x = (float)wl_fixed_to_double(inX) / me->width;
    me->y = (float)wl_fixed_to_double(inY) / me->height;

    // touch down
    if (me->verbose)
    {
        LOGD_VERBOSE((aauto_input, "TouchListener touch down at %.3fx%.3f id:%d", me->x, me->y, inID));
    }

    // in case of SingleTouchDeviceType, handle only events with inID equal to 0
    if ((inID == 0) || (me->wlDeviceType != SingleTouchDeviceType)) {
        me->report.setTouch(inID, me->x, me->y, TActionDown);
        me->report.SendInput();
    }
}

void TouchListener::handleUp(void* inData, struct wl_touch* inTouch, uint32_t inSerial,
        uint32_t inTime, int32_t inID)
{
    (void)inData;
    (void)inTouch;
    (void)inSerial;
    (void)inTime;

    auto me = static_cast<TouchListener*>(inData);

    // touch up
    if (me->verbose)
    {
        LOGD_VERBOSE((aauto_input, "TouchListener touch up id:%d", inID));
    }

    // in case of SingleTouchDeviceType, handle only events with inID equal to 0
    if ((inID == 0) || (me->wlDeviceType != SingleTouchDeviceType)) {
        me->report.setTouch(inID, 0, 0, TActionUp);
        me->report.SendInput();
    }
}

void TouchListener::handleMotion(void* inData, struct wl_touch* inTouch, uint32_t inTime,
        int32_t inID, wl_fixed_t inX, wl_fixed_t inY)
{
    (void)inData;
    (void)inTouch;
    (void)inTime;

    auto me = static_cast<TouchListener*>(inData);

    me->x = (float)wl_fixed_to_double(inX) / me->width;
    me->y = (float)wl_fixed_to_double(inY) / me->height;

    // touch motion
    if (me->verbose)
    {
        LOGD_VERBOSE((aauto_input, "TouchListener touch motion id:%d", inID));
    }

    // in case of SingleTouchDeviceType, handle only events with inID equal to 0
    if ((inID == 0) || (me->wlDeviceType != SingleTouchDeviceType)) {
        me->report.setTouch(inID, me->x, me->y, TActionMotion);
        me->report.SendInput();
    }
}

void TouchListener::handleFrame(void* inData, struct wl_touch* inTouch)
{
    (void)inData;
    (void)inTouch;

    // do nothing
}

void TouchListener::handleCancel(void* inData, struct wl_touch* inTouch)
{
    (void)inData;
    (void)inTouch;

    // do nothing
}

} } // namespace adit { namespace aauto
